unit IWDBExtCtrls;
{PUBDIST}
	
interface

uses
  {$IFDEF VSNET}
  System.ComponentModel, System.ComponentModel.Design, System.Drawing,
  System.Drawing.Design, System.Data, IWConnectorsCache,
  IWNetClasses, IWNetComponent, AdoNetDb, 
  {$ENDIF}
  {$IFDEF Linux} QGraphics, {$ELSE}Graphics,{$ENDIF}
  {$IFDEF Linux}
    IWJpeg,
    IWCLXClasses,
  {$ELSE}
    {$IFDEF CLR}
      IWNetJPEG,
    {$ELSE}
      Jpeg,
    {$ENDIF}
    {$IFNDEF VSNET}
    IWVCLClasses,
    {$ENDIF}
  {$ENDIF}
  Classes, DB, IWDBStdCtrls,
  IWExtCtrls, IWHTMLTag, IWRenderContext, IWBaseInterfaces;

type
  TIWImageDataLink = class(TIWDataLink)
  private
    procedure CheckAndUpdateImage;
  protected
    procedure ActiveChanged; override;
    {$IFDEF CLR}
    procedure DataEvent(Event: TDataEvent; Info: TObject); override;
    {$ELSE}
    procedure DataEvent(Event: TDataEvent; Info: Longint); override;
    {$ENDIF}
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBImage.bmp}
  TIWDBImage = class;
  [
    ToolboxItem(true),
    ToolboxBitmap(typeof(TIWDBImage), 'TIWDBImage.bmp'),
    TIWToolPalette('Intraweb DB Controls')]
  {$ENDIF}
  TIWDBImage = class(TIWDynamicImage)
  private
    FDataLink: TIWImageDataLink;
    {$IFNDEF VSNET}
    procedure SetDataSource(const Value: TDataSource);
    {$ENDIF}
  protected
    FDataField: string;
    FDataSource: TDataSource;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure SetDataTable(const ADataTable: System.Data.DataTable);
    function GetDataTable: System.Data.DataTable;
    function ShouldSerializeDataTable: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    property FriendlyName;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property DataTable: System.Data.DataTable read GetDataTable write SetDataTable;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write SetDataSource;
    {$ENDIF}
    property TabOrder;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBRadioGroup.bmp}
  TIWDBRadioGroup = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBRadioGroup), 'TIWDBRadioGroup.bmp'),
    TIWToolPalette('Intraweb DB Controls')]
  {$ENDIF}
  TIWDBRadioGroup = class(TIWCustomRadioGroup, IIWInputControl)
  private
    FDataLink: TIWDataLink;
    {$IFNDEF VSNET}
    procedure SetDataSource(const Value: TDataSource);
    {$ENDIF}
  protected
    FTrimValues: Boolean;
    FAutoEditable: Boolean;
    FDataField: string;
    FDataSource: TDataSource;
    FValues: TIWStringList;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure SetValues(const AValue: TIWStringList);
    procedure SetValue(const AValue: string); override;
    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure SetDataTable(const ADataTable: System.Data.DataTable);
    function GetDataTable: System.Data.DataTable;
    function ShouldSerializeDataTable: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    property TrimValues: Boolean read FTrimValues write FTrimValues;
    property AutoEditable: Boolean read FAutoEditable write FAutoEditable;
    property Editable;
    {$IFDEF CLR}
    property WebFont;
    {$ELSE}
    property Font;
    {$ENDIF}
    property Layout;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    property FriendlyName;
    {$IFDEF VSNET}
    property DataTable: System.Data.DataTable read GetDataTable write SetDataTable;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write SetDataSource;
    {$ENDIF}
    property Values: TIWStringList read FValues write SetValues;
    property Items;
  end;

implementation

uses
  IWDBCommon, IWControl, SWSystem,
  {$IFDEF VSNET}System.Runtime.InteropServices,{$ENDIF}
  SysUtils;

{ TIWDBImage }

destructor TIWDBImage.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  FreeAndNil(FDataLink);
  inherited;
end;

procedure TIWDBImage.InitControl;
begin
  inherited;
  FDataLink := TIWImageDataLink.Create(Self);
  FDataField := '';
end;

{$IFDEF VSNET}
procedure TIWDBImage.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBImage.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited;
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBImage.SetDataTable(const ADataTable: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(ADataTable);
  FDataLink.DataSource := FDataSource;
end;

function TIWDBImage.ShouldSerializeDataTable: Boolean;
begin
  result := Assigned(DataTable);
end;

function TIWDBImage.GetDataTable: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;

{$ENDIF}

{$IFDEF VSNET}
function StructureToBytes(const Struct: TObject): TBytes;
var
  Buffer: IntPtr;
begin
  Buffer := Marshal.AllocHGlobal(Marshal.SizeOf(TypeOf(Struct)));
  try
    Marshal.StructureToPtr(Struct, Buffer, False);
    SetLength(Result, Marshal.SizeOf(TypeOf(Struct)));
    Marshal.Copy(Buffer, Result, 0, Length(Result));
  finally
    Marshal.FreeHGlobal(Buffer);
  end;
end;

function TIWDBImage.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LField: TField;
  S: TMemoryStream;
  LBmp : TBitmap;
  LBuffer : TBytes;
  LObject : TObject;
begin
  // Clear first in case the datafield is empty so we dont display the last image
  Picture.Graphic := nil;
  if CheckDataSource(FDataSource, DataField, LField) then
  begin
    if not LField.IsNull then
    begin
      S := TMemoryStream.Create;
      try
        TADONETField(LField).GetData(LObject);
        if TypeOf(LObject).Equals(TypeOf(TBytes)) then
        begin
          LBuffer := TBytes(LObject)
        end
        else
        begin
          LBuffer := StructureToBytes(LObject);
        end;
        S.WriteBuffer(LBuffer, Length(LBuffer));
        SetImage(System.Drawing.Image.FromStream(TStreamToCLRStream.GetStream(S)));
      finally
        FreeAndNil(S);
      end;
    end;
  end;
  Result := inherited RenderHTML(AContext);
end;
{$ELSE}
function TIWDBImage.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LField: TField;
  S: TMemoryStream;
  Ljpg: TJPEGImage;
  LHeader: array [0..1] of byte;
begin
  // Clear first in case the datafield is empty so we dont display the last image
  Picture.Graphic := nil;
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if LField.IsBlob then begin
      S := TMemoryStream.Create;
      try
        TBlobField(LField).SaveToStream(S);
        // Find file type
        S.Position := 0;
        S.Read(LHeader, 2);
        S.Position := 0;
        if (LHeader[0] = $FF) and (LHeader[1] = $D8) then begin
          LJPg := TJPEGImage.Create;
          try
            LJpg.LoadFromStream(S);
            FPicture.Assign(LJPG);
          finally
            FreeAndNil(LJpg);
          end;
        end else begin
          FPicture.Assign(LField);
        end;
      finally
        FreeAndNil(S);
      end;
    end;
  end;
  Result := inherited RenderHTML(AContext);
end;
{$ENDIF}

{$IFNDEF VSNET}
procedure TIWDBImage.SetDataSource(const Value: TDataSource);
begin
  FDataSource := Value;
  FDataLink.DataSource := FDataSource;
end;
{$ENDIF}

{ TIWDBRadioGroup }

destructor TIWDBRadioGroup.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  FreeAndNil(FDatalink);
  FreeAndNil(FValues);
  inherited Destroy;
end;

{$IFDEF VSNET}
procedure TIWDBRadioGroup.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBRadioGroup.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBRadioGroup.SetDataTable(const ADataTable: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(ADataTable);
  FDataLink.DataSource := FDataSource;
end;

function TIWDBRadioGroup.ShouldSerializeDataTable: Boolean;
begin
  result := Assigned(DataTable);
end;

function TIWDBRadioGroup.GetDataTable: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

procedure TIWDBRadioGroup.InitControl;
begin
  inherited;
  FTrimValues := True;
  FValues := TIWStringList.Create;
  FDataLink := TIWDataLink.Create(Self);
  FDataField := '';
end;

function TIWDBRadioGroup.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LField: TField;
begin
  if CheckDataSource(FDataSource, DataField, LField) then begin
     ItemIndex := Values.IndexOf(IIF(TrimValues, Trim(GetFieldText(LField)), GetFieldText(LField)));
      if AutoEditable then begin
        Editable := InEditMode(FDataSource.Dataset);
      end;
     if ItemIndex<0 then
      ItemIndex := Items.IndexOf(IIF(TrimValues, Trim(GetFieldText(LField)), GetFieldText(LField)));
  end else begin
    ItemIndex := -1;
    if AutoEditable then begin
      Editable := False;
    end;
  end;
  Result := inherited RenderHTML(AContext);
end;

{$IFNDEF VSNET}
procedure TIWDBRadioGroup.SetDataSource(const Value: TDataSource);
begin
  FDataSource := Value;
  FDataLink.DataSource := FDataSource;
end;
{$ENDIF}

procedure TIWDBRadioGroup.SetValue(const AValue: string);
var
  s: string;
  LField: TField;
begin
  inherited SetValue(AValue);
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if FItemIndex > -1 then begin
      with Items do begin
        if FValues.Count > FItemIndex then begin
          s := FValues[FItemIndex]
        end else begin
          s := Items[FItemIndex]
        end;
      end;
    end else begin
      s := '';
    end;
    if (GetFieldText(LField) <> s) then begin
      FDataSource.Edit;
      LField.Text := s;
    end;
  end;
end;

procedure TIWDBRadioGroup.SetValues(const AValue: TIWStringList);
begin
  Values.Assign(AValue);
end;

{ TIWImageDataLink }

procedure TIWImageDataLink.ActiveChanged;
begin
  CheckAndUpdateImage;
  inherited;
end;

procedure TIWImageDataLink.CheckAndUpdateImage;
var
  LField: TField;
  S: TMemoryStream;
  Ljpg: TJPEGImage;
  LHeader: array [0..1] of byte;
begin
  if Assigned(Control) then begin
    with TIWDBImage(Control) do begin
      if IsDesignMode then begin
        // Clear first in case the datafield is empty so we dont display the last image
        Picture.Graphic := nil;
        if CheckDataSource(FDataSource, DataField, LField) then begin
          if LField.IsBlob then begin
            S := TMemoryStream.Create;
            try
              TBlobField(LField).SaveToStream(S);
              // Find file type
              S.Position := 0;
              S.Read(LHeader, 2);
              S.Position := 0;
              if (LHeader[0] = $FF) and (LHeader[1] = $D8) then begin
                LJPg := TJPEGImage.Create;
                try
                  LJpg.LoadFromStream(S);
                  Picture.Assign(LJPG);
                finally
                  FreeAndNil(LJpg);
                end;
              end else begin
                Picture.Assign(LField);
              end;
            finally
              FreeAndNil(S);
            end;
          end;
        end;
      end;
    end;
  end;
end;

{$IFDEF CLR}
procedure TIWImageDataLink.DataEvent(Event: TDataEvent; Info: TObject);
{$ELSE}
procedure TIWImageDataLink.DataEvent(Event: TDataEvent; Info: Longint);
{$ENDIF}
begin
  case Event of
    deDataSetChange, deDataSetScroll: begin
 //     CheckAndUpdateImage;
    end;
  end;
  inherited;
end;

end.
